<?php
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

$body = json_decode(file_get_contents('php://input'), true);
$token = trim((string)($body['token'] ?? ''));

if (!$token || strlen($token) < 20) {
  json_response(['ok' => false, 'error' => 'NO_TOKEN'], 401);
}

$tokenHash = secure_hash($token);

// Validate session -> get email
$sessionsPath = DATA_DIR . '/sessions.json';
$sessions = read_json($sessionsPath, []);

if (!isset($sessions[$tokenHash])) {
  json_response(['ok' => false, 'error' => 'INVALID_SESSION'], 401);
}

$sess = $sessions[$tokenHash];
if (now() > (int)$sess['expires_at']) {
  unset($sessions[$tokenHash]);
  write_json($sessionsPath, $sessions);
  json_response(['ok' => false, 'error' => 'SESSION_EXPIRED'], 401);
}

$email = $sess['email'];

$trialPath = DATA_DIR . '/trials.json';
$trials = read_json($trialPath, []);

// Start only if not exists
if (!isset($trials[$email])) {
  $start = now();
  $end = $start + (15 * 60);
  $trials[$email] = [
    'started_at' => $start,
    'expires_at' => $end
  ];
  write_json($trialPath, $trials);
  log_line("trial_start email={$email} expires_at={$end}");
}

$trial = $trials[$email];
$expiresAt = (int)$trial['expires_at'];
$active = now() < $expiresAt;
$left = max(0, $expiresAt - now());

json_response([
  'ok' => true,
  'email' => $email,
  'trial_started' => true,
  'trial_active' => $active,
  'trial_started_at' => (int)$trial['started_at'],
  'trial_expires_at' => $expiresAt,
  'seconds_left' => $left
]);
