<?php
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

$body = json_decode(file_get_contents('php://input'), true);
if (!is_array($body)) json_response(['ok' => false, 'error' => 'INVALID_JSON'], 400);

$secret = (string)($body['secret'] ?? '');
if (!$secret || !defined('ADMIN_SECRET') || !hash_equals(ADMIN_SECRET, $secret)) {
  json_response(['ok' => false, 'error' => 'UNAUTHORIZED'], 401);
}

$email = normalize_email((string)($body['email'] ?? ''));
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_response(['ok' => false, 'error' => 'INVALID_EMAIL'], 400);
}

$trialPath = DATA_DIR . '/trials.json';
$trials = read_json($trialPath, []);

if (isset($trials[$email])) {
  unset($trials[$email]);
  write_json($trialPath, $trials);
  log_line("admin_trial reset email={$email}");
}

json_response(['ok' => true, 'action' => 'reset', 'email' => $email]);
