<?php
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

$body = json_decode(file_get_contents('php://input'), true);
$token = trim((string)($body['token'] ?? ''));

if (!$token || strlen($token) < 20) {
  json_response(['ok' => false, 'error' => 'NO_TOKEN'], 401);
}

$tokenHash = secure_hash($token);

// 1) Validate session -> get email
$sessionsPath = DATA_DIR . '/sessions.json';
$sessions = read_json($sessionsPath, []);

if (!isset($sessions[$tokenHash])) {
  json_response(['ok' => false, 'error' => 'INVALID_SESSION'], 401);
}

$sess = $sessions[$tokenHash];
if (now() > (int)$sess['expires_at']) {
  unset($sessions[$tokenHash]);
  write_json($sessionsPath, $sessions);
  json_response(['ok' => false, 'error' => 'SESSION_EXPIRED'], 401);
}

$email = $sess['email'];

// 2) Whitelist lookup
$wlPath = DATA_DIR . '/whitelist.json';
$wl = read_json($wlPath, []);

if (!isset($wl[$email])) {
  json_response([
    'ok' => true,
    'whitelisted' => false,
    'email' => $email
  ]);
}

$entry = $wl[$email];
$expiresAt = $entry['expires_at'] ?? null;

if ($expiresAt !== null && now() > (int)$expiresAt) {
  // expired whitelist entry
  json_response([
    'ok' => true,
    'whitelisted' => false,
    'email' => $email,
    'reason' => 'WHITELIST_EXPIRED'
  ]);
}

$features = $entry['features'] ?? [];
$label = $entry['label'] ?? 'whitelist';

json_response([
  'ok' => true,
  'whitelisted' => true,
  'email' => $email,
  'label' => $label,
  'features' => $features,
  'expires_at' => $expiresAt
]);
