<?php
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

$body = json_decode(file_get_contents('php://input'), true);
if (!is_array($body)) {
  json_response(['ok' => false, 'error' => 'INVALID_JSON'], 400);
}

$secret = (string)($body['secret'] ?? '');
if (!$secret || !defined('ADMIN_SECRET') || !hash_equals(ADMIN_SECRET, $secret)) {
  json_response(['ok' => false, 'error' => 'UNAUTHORIZED'], 401);
}

$action = strtolower(trim((string)($body['action'] ?? 'set'))); // set | remove | get
$email  = normalize_email((string)($body['email'] ?? ''));

$wlPath = DATA_DIR . '/whitelist.json';
$wl = read_json($wlPath, []);

if ($action === 'get') {
  if (!$email) {
    // return all
    json_response(['ok' => true, 'count' => count($wl), 'whitelist' => $wl]);
  }
  $entry = $wl[$email] ?? null;
  json_response(['ok' => true, 'email' => $email, 'entry' => $entry]);
}

if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_response(['ok' => false, 'error' => 'INVALID_EMAIL'], 400);
}

if ($action === 'remove') {
  if (isset($wl[$email])) {
    unset($wl[$email]);
    write_json($wlPath, $wl);
    log_line("admin_whitelist remove email={$email}");
  }
  json_response(['ok' => true, 'action' => 'remove', 'email' => $email]);
}

if ($action !== 'set') {
  json_response(['ok' => false, 'error' => 'INVALID_ACTION'], 400);
}

// action: set
$label = trim((string)($body['label'] ?? 'whitelist'));
$features = $body['features'] ?? [];
$expiresAt = $body['expires_at'] ?? null;

// validate features
if (!is_array($features)) {
  json_response(['ok' => false, 'error' => 'FEATURES_NOT_ARRAY'], 400);
}
$features = array_values(array_unique(array_map('strval', $features)));

// validate expires_at
if ($expiresAt !== null) {
  if (is_string($expiresAt) && ctype_digit($expiresAt)) $expiresAt = (int)$expiresAt;
  if (!is_int($expiresAt) || $expiresAt < 0) {
    json_response(['ok' => false, 'error' => 'INVALID_EXPIRES_AT'], 400);
  }
}

$wl[$email] = [
  'label' => $label,
  'features' => $features,
  'expires_at' => $expiresAt
];

write_json($wlPath, $wl);
log_line("admin_whitelist set email={$email} label={$label}");

json_response([
  'ok' => true,
  'action' => 'set',
  'email' => $email,
  'entry' => $wl[$email]
]);
