<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/_token.php';
require_once __DIR__ . '/_ls.php';
require_once __DIR__ . '/_entitlements.php';

// CORS + preflight
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type');
  http_response_code(204);
  exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

$body = json_decode(file_get_contents('php://input'), true);
$token = (string)($body['token'] ?? '');
$license_key = trim((string)($body['license_key'] ?? ''));
$instance_name = trim((string)($body['instance_name'] ?? ''));

$email = auth_email_from_token($token);
if (!$email) {
  json_response(['ok' => false, 'error' => 'UNAUTHORIZED'], 401);
}

if (!$license_key || !$instance_name) {
  json_response(['ok' => false, 'error' => 'MISSING_FIELDS'], 400);
}

$r = ls_activate($license_key, $instance_name);
if (!$r['ok']) {
  $err = $r['data']['error'] ?? $r['error'] ?? 'LS_ACTIVATE_FAILED';
  json_response(['ok' => false, 'error' => $err], 400);
}

$data = $r['data'];
if (empty($data['activated'])) {
  json_response(['ok' => false, 'error' => $data['error'] ?? 'NOT_ACTIVATED'], 400);
}

$meta = $data['meta'] ?? [];
$variant_id = (int)($meta['variant_id'] ?? 0);
$plan = plan_from_variant_id($variant_id);

if (!$plan) {
  json_response(['ok' => false, 'error' => 'UNKNOWN_PLAN'], 400);
}

// security: LS customer email must match verified email
$lsEmail = normalize_email($meta['customer_email'] ?? '');
if ($lsEmail && $lsEmail !== $email) {
  json_response(['ok' => false, 'error' => 'LICENSE_EMAIL_MISMATCH'], 403);
}

$instance_id = (string)($data['instance']['id'] ?? '');

$paidPath = DATA_DIR . '/paid.json';
$paid = read_json($paidPath, []);
$paid[$email] = [
  'email' => $email,
  'license_key' => $license_key,
  'instance_id' => $instance_id,
  'variant_id' => $variant_id,
  'plan' => $plan,
  'created_at' => $paid[$email]['created_at'] ?? now(),
  'updated_at' => now(),
];
write_json($paidPath, $paid);

json_response([
  'ok' => true,
  'plan' => $plan,
  'variant_id' => $variant_id,
  'instance_id' => $instance_id,
]);
