<?php
// Minimal token lookup helper.
// Assumes your verify_code.php stores tokens in DATA_DIR.'/tokens.json'.

function auth_email_from_token($token) {
  $token = trim((string)$token);
  if ($token === '') return '';

  $h = secure_hash($token);
  $path = DATA_DIR . '/tokens.json';
  $tokens = read_json($path, []);

  // format A: { token_hash: {email, exp} }
  if (isset($tokens[$h]) && is_array($tokens[$h])) {
    $rec = $tokens[$h];
    $email = normalize_email($rec['email'] ?? '');
    $exp = (int)($rec['exp'] ?? 0);
    if ($email && ($exp === 0 || now() <= $exp)) return $email;
  }

  // format B: [{token_hash,email,exp}, ...]
  if (array_is_list($tokens)) {
    foreach ($tokens as $rec) {
      if (!is_array($rec)) continue;
      $rh = (string)($rec['token_hash'] ?? $rec['hash'] ?? '');
      if ($rh !== $h) continue;
      $email = normalize_email($rec['email'] ?? '');
      $exp = (int)($rec['exp'] ?? 0);
      if ($email && ($exp === 0 || now() <= $exp)) return $email;
    }
  }

  return '';
}
