<?php
// LemonSqueezy License API helper
// Docs:
// - Activate: /v1/licenses/activate
// - Validate: /v1/licenses/validate

function ls_post($path, $fields) {
  $url = 'https://api.lemonsqueezy.com' . $path;

  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: application/json'
  ]);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));

  $raw = curl_exec($ch);
  $err = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($raw === false) {
    return ['ok' => false, 'http' => 0, 'error' => $err ?: 'CURL_FAILED'];
  }

  $data = json_decode($raw, true);
  if (!is_array($data)) {
    return ['ok' => false, 'http' => $code, 'error' => 'NON_JSON', 'raw' => substr($raw, 0, 500)];
  }

  return ['ok' => ($code >= 200 && $code < 300), 'http' => $code, 'data' => $data];
}

function ls_activate($license_key, $instance_name) {
  // required params: license_key, instance_name citeturn1view0
  return ls_post('/v1/licenses/activate', [
    'license_key' => $license_key,
    'instance_name' => $instance_name,
  ]);
}

function ls_validate($license_key, $instance_id = '') {
  // required: license_key; optional: instance_id citeturn2view0
  $fields = ['license_key' => $license_key];
  if ($instance_id) $fields['instance_id'] = $instance_id;
  return ls_post('/v1/licenses/validate', $fields);
}
