<?php
// Variant IDs (your LemonSqueezy variants)
// Basic: 1203663
// Pro: 1203680
// Ultra: 1203684
// Ultra Max: 1203696

define('LS_VARIANT_BASIC', 1203663);
define('LS_VARIANT_PRO', 1203680);
define('LS_VARIANT_ULTRA', 1203684);
define('LS_VARIANT_ULTRA_MAX', 1203696);

function plan_from_variant_id($variant_id) {
  $vid = (int)$variant_id;
  if ($vid === LS_VARIANT_BASIC) return 'Basic';
  if ($vid === LS_VARIANT_PRO) return 'Pro';
  if ($vid === LS_VARIANT_ULTRA) return 'Ultra';
  if ($vid === LS_VARIANT_ULTRA_MAX) return 'Ultra MAX';
  return null;
}

function allowed_from_plan($plan) {
  switch ($plan) {
    case 'Basic':
      return ['fun3'];
    case 'Pro':
      return ['fun3','fun2'];
    case 'Ultra':
      return ['fun1','fun2','fun3'];
    case 'Ultra MAX':
      // allow everything now + future features
      return ['all','future_all'];
    default:
      return [];
  }
}
