<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type');
  http_response_code(204);
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 200);
}

$body = json_decode(file_get_contents('php://input'), true);
$email = normalize_email($body['email'] ?? '');
$code  = trim((string)($body['code'] ?? ''));

if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_response(['ok' => false, 'error' => 'INVALID_EMAIL'], 200);
}
if (!preg_match('/^\d{6}$/', $code)) {
  json_response(['ok' => false, 'error' => 'INVALID_CODE_FORMAT'], 200);
}

$ip = get_client_ip();

$pendingPath = DATA_DIR . '/pending_codes.json';
$pending = read_json($pendingPath, []);

if (!isset($pending[$email])) {
  json_response(['ok' => false, 'error' => 'NO_PENDING_CODE'], 200);
}

$entry = $pending[$email];

if (now() > (int)$entry['expires_at']) {
  unset($pending[$email]);
  write_json($pendingPath, $pending);
  json_response(['ok' => false, 'error' => 'CODE_EXPIRED'], 200);
}

// brute protection
$tries = (int)($entry['tries'] ?? 0);
if ($tries >= 10) {
  json_response(['ok' => false, 'error' => 'TOO_MANY_TRIES'], 200);
}

$expected = (string)($entry['code_hash'] ?? '');
$given = secure_hash($email . ':' . $code);

if (!hash_equals($expected, $given)) {
  $pending[$email]['tries'] = $tries + 1;
  write_json($pendingPath, $pending);
  json_response(['ok' => false, 'error' => 'WRONG_CODE'], 200);
}

// success: create token
$token = bin2hex(random_bytes(24));
$tokenHash = secure_hash($token);
$expiresAt = now() + TOKEN_TTL_SECONDS;

$sessionsPath = DATA_DIR . '/sessions.json';
$sessions = read_json($sessionsPath, []);

$sessions[$tokenHash] = [
  'email' => $email,
  'created_at' => now(),
  'expires_at' => $expiresAt,
  'ip' => $ip
];

write_json($sessionsPath, $sessions);

// delete pending
unset($pending[$email]);
write_json($pendingPath, $pending);

log_line("verify_code OK email={$email} ip={$ip}");

json_response([
  'ok' => true,
  'token' => $token,
  'email' => $email,
  'expires_at' => $expiresAt
]);
