<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

require_once __DIR__ . '/../config.php';


if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type');
  http_response_code(204);
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 200);
}

$body = json_decode(file_get_contents('php://input'), true);
$email = normalize_email($body['email'] ?? '');

if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_response(['ok' => false, 'error' => 'INVALID_EMAIL'], 200);
}

$ip = get_client_ip();

// Rate limit storage
$ratePath = DATA_DIR . '/rate.json';
$rate = read_json($ratePath, ['by_email' => [], 'by_ip' => []]);

$hourKey = (string) floor(now() / 3600);

function bump(&$map, $key, $hourKey) {
  if (!isset($map[$key])) $map[$key] = [];
  if (!isset($map[$key][$hourKey])) $map[$key][$hourKey] = 0;
  $map[$key][$hourKey] += 1;
}

function sum_hour($map, $key, $hourKey) {
  if (!isset($map[$key]) || !isset($map[$key][$hourKey])) return 0;
  return (int)$map[$key][$hourKey];
}

$emailCount = sum_hour($rate['by_email'], $email, $hourKey);
$ipCount = sum_hour($rate['by_ip'], $ip, $hourKey);

if ($emailCount >= SEND_LIMIT_PER_HOUR) {
  json_response(['ok' => false, 'error' => 'EMAIL_RATE_LIMIT'], 200);
}
if ($ipCount >= SEND_LIMIT_PER_IP_HOUR) {
  json_response(['ok' => false, 'error' => 'IP_RATE_LIMIT'], 200);
}

// Generate code
$code = random_digits(CODE_LENGTH);
$codeHash = secure_hash($email . ':' . $code);
$expiresAt = now() + CODE_TTL_SECONDS;

// Save pending code
$pendingPath = DATA_DIR . '/pending_codes.json';
$pending = read_json($pendingPath, []);

$pending[$email] = [
  'code_hash' => $codeHash,
  'expires_at' => $expiresAt,
  'ip' => $ip,
  'tries' => 0
];

write_json($pendingPath, $pending);

// Bump rate limits
bump($rate['by_email'], $email, $hourKey);
bump($rate['by_ip'], $ip, $hourKey);
write_json($ratePath, $rate);

// Send email (SMTP via PHPMailer)
$subject = APP_NAME . " - код за потвърждение";
$message = "Здравей!\n\nТвоят код е: {$code}\nВалиден е 10 минути.\n\nАко не си ти - игнорирай това съобщение.\n";

$sent = false;

if (defined('SMTP_ENABLED') && SMTP_ENABLED) {
  // PHPMailer files must exist at /chrome-ext/api/lib/
  require_once __DIR__ . '/../lib/PHPMailer.php';
  require_once __DIR__ . '/../lib/SMTP.php';
  require_once __DIR__ . '/../lib/Exception.php';

  $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

  try {
    $mail->isSMTP();
    $mail->Timeout = 10; // seconds
    $mail->SMTPKeepAlive = false;
    $mail->SMTPDebug = 0;
    $mail->Debugoutput = function($str, $level) { log_line("SMTP_DEBUG L{$level}: " . $str); };
    $mail->Host = SMTP_HOST;
    $mail->SMTPAuth = true;
    $mail->Username = SMTP_USERNAME;
    $mail->Password = SMTP_PASSWORD;
    $mail->Port = SMTP_PORT;

    if (SMTP_SECURE === 'tls') {
      $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
    } elseif (SMTP_SECURE === 'ssl') {
      $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS;
    }

    $mail->CharSet = 'UTF-8';
    $mail->setFrom(MAIL_FROM, MAIL_FROM_NAME);
    $mail->addAddress($email);
    $mail->Subject = $subject;
    $mail->Body = $message;

    $mail->send();
    $sent = true;
  } catch (Exception $e) {
    log_line("send_code SMTP_FAIL email={$email} ip={$ip} err=" . $mail->ErrorInfo);
    $sent = false;
  }
}

log_line("send_code email={$email} ip={$ip} sent=" . ($sent ? "1" : "0"));

if (!$sent) {
  json_response(['ok' => false, 'error' => 'MAIL_FAILED'], 200);
}

json_response(['ok' => true, 'message' => 'CODE_SENT']);
