<?php
require_once __DIR__ . '/../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok' => false, 'error' => 'METHOD_NOT_ALLOWED'], 405);
}

$body = json_decode(file_get_contents('php://input'), true);
if (!is_array($body)) json_response(['ok' => false, 'error' => 'INVALID_JSON'], 400);

$secret = (string)($body['secret'] ?? '');
if (!$secret || !defined('ADMIN_SECRET') || !hash_equals(ADMIN_SECRET, $secret)) {
  json_response(['ok' => false, 'error' => 'UNAUTHORIZED'], 401);
}

$email = normalize_email((string)($body['email'] ?? ''));
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_response(['ok' => false, 'error' => 'INVALID_EMAIL'], 400);
}

// whitelist
$wlPath = DATA_DIR . '/whitelist.json';
$wl = read_json($wlPath, []);
$wlEntry = $wl[$email] ?? null;
$wlActive = false;
if ($wlEntry) {
  $exp = $wlEntry['expires_at'] ?? null;
  $wlActive = ($exp === null) ? true : (now() <= (int)$exp);
}

// trial
$trialPath = DATA_DIR . '/trials.json';
$trials = read_json($trialPath, []);
$trial = $trials[$email] ?? null;

$trialExists = $trial ? true : false;
$trialActive = false;
$trialLeft = 0;

if ($trial) {
  $expiresAt = (int)($trial['expires_at'] ?? 0);
  $trialActive = now() < $expiresAt;
  $trialLeft = max(0, $expiresAt - now());
}

json_response([
  'ok' => true,
  'email' => $email,
  'whitelist' => [
    'exists' => (bool)$wlEntry,
    'active' => $wlActive,
    'entry' => $wlEntry
  ],
  'trial' => [
    'exists' => $trialExists,
    'active' => $trialActive,
    'seconds_left' => $trialLeft,
    'entry' => $trial
  ]
]);
